/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */

'use strict';

define([ 'Portal', 'backbone', 'marionette',
    'applets/wound-care-applet/core/extensions/list-generator/Model',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/AppletLayout',
    'applets/wound-care-applet/core/extensions/list-generator/core/models/resources/LocationServiceResources',
    'applets/wound-care-applet/core/extensions/list-generator/core/models/wards/Wards',
    'applets/wound-care-applet/core/extensions/list-generator/core/models/patients/Patients',
    'applets/wound-care-applet/core/extensions/list-generator/core/models/resources/PatientSearchResources'
    ],
    function (Portal, Backbone, Marionette) {
        return Portal.module('ListGenerator',
            function (ListGenerator, Portal, Backbone, Marionette, $, _) {
                ListGenerator.Controller = Marionette.Controller.extend({
                    initialize: function (options) {
                        var self = this;
                        
                        ListGenerator.vent = new Backbone.Wreqr.EventAggregator();

                        this.bootstrapModel = new Backbone.Model({
                            name: 'search',
                            title: 'Search',
                            type: 'Applet',
                            url: '#search',
                            display: true,
                            focus: 'modal' //need to get this from package.json
                        });

                        if (typeof options !== 'undefined' && options.focus === "")

                        Portal.vent.trigger('add:applet', this.bootstrapModel);
                        Portal.execute('show-applet-search', this.bootstrapModel);

                        this._configureSearch(options);
                        // iniitalize title for default search type
                        this._switchType(ListGenerator.model.get('searchType'));

                        ListGenerator.vent.once('load:searches', this.loadSearches, this);

                        ListGenerator.vent.on('set:patient-context', this.setPatientContext, this);
                    },
                    onAppletLoad: function () {
                        Portal.vent.trigger('load:css', Portal.baseUrl + 'applets/wound-care-applet/core/extensions/list-generator/_assets/css/applet.css');
                        // ListGenerator does not trigger load:applet; its title is displayed in the modal dialog
                    },
                    search: function (type) {
                        ListGenerator.vent.trigger('load:searches');

                        if ( (typeof type !== 'undefined' && type !== ListGenerator.model.get('searchType')) ) {
                            this._switchType( type );
                        } // else opens search applet with last selected type

                        if ( typeof this.layout === 'undefined' || this.layout.isClosed ) {
                            this.layout = new ListGenerator.Layout({ model: ListGenerator.model, scrollableContent: true });
                            var pattern = new RegExp('^search'),
                                fragment = Backbone.history.previousFragment;

                            if ( pattern.test(fragment) ) {
                                fragment = '';
                            }
                        }
                    },
										getLayout:function(type){
											this.search(type);
											return this.layout;
										},
                    _configureSearch: function (options) {
                        if (typeof options !== 'undefined' && typeof options.types !== 'undefined') {
                            var optionsConfig = {};

                            _.each(options.types, function(type) {
                                if (typeof type === "string") {
                                    switch (type) {
                                        case 'clinic':
                                        case 'clinics':
                                            optionsConfig.clinics = { name: "Clinic", title: "Clinic Search" };
                                            break;
                                        case 'ward':
                                        case 'wards':
                                            optionsConfig.wards = { name: "Ward", title: "Ward Search" };
                                            break;
                                        case 'recent':
                                            optionsConfig.recent = { name: "Last 20", title: "Last 20 Patients" };
                                            break;
                                        case 'patient':
                                        case 'patients':
                                            optionsConfig.patients = { name: "Patient", title: "Patient Search" };
                                            break;
                                    }
                                } else { // type is object with id, name, title
                                    optionsConfig[type.id] = { name: type.name, title: type.title };
                                }
                            });

                            ListGenerator.model.set( 'configTypes', optionsConfig );
                        } // else set to defaults in ListGenerator.model
                    },
                    _switchType: function (type) {
                        // allow singular spelling of base search types
                        switch (type) {
                            case 'clinic':
                                type = 'clinics';
                                break;
                            case 'ward':
                                type = 'wards';
                                break;
                            /*
                            case 'myList':
                                type = 'my-list';
                                break;
                            */
                            case 'patient':
                                type = 'patients';
                                break;
                        }
                        if (typeof ListGenerator.model.get('configTypes')[type] !== "undefined") {
                            ListGenerator.model.set({
                                searchType: type,
                                title: ListGenerator.model.get('configTypes')[type].title
                            });
                        }
                        // else type is not included in options or was not typed correctly
                        //  use default or last selected search type
                    },
                    loadSearches: function(options) {
                        var self = this,
                            config = ListGenerator.model.get('configTypes');

                        _.each(config, function(search, type) {
                            ListGenerator.vent.once("load:search:" + type, function(options) {
                                var searchData = {
                                    id: type
                                };
                                if (typeof options !== 'undefined') {
                                    if ( !!options.locationListView ) {
                                        searchData.location = '';
                                        searchData.locationFilter = '';

                                        if (typeof options.locationListView === 'string') {
                                            var location = options.locationListView;
                                            var LocationCollection = (location === 'clinics') ? ListGenerator.Clinics : ListGenerator.Wards;

                                            if (location === 'clinic' || location === 'clinics') {
                                                searchData.locationCollection = new LocationCollection( [], {
                                                    url: ListGenerator.locationServiceResources.get('clinics').get('href')
                                                } );
                                            } else if (location === 'ward' || location === 'wards') {
                                                searchData.locationCollection = new LocationCollection( [], {
                                                    url: ListGenerator.locationServiceResources.get('wards').get('href')
                                                } );
                                            }
                                        } else if (typeof options.locationListView !== 'undefined') {
                                            searchData.locationListView = options.locationListView;
                                        }
                                    }
                                    if ( typeof options.patientListView !== 'undefined' ) {
                                        searchData.patientListView = options.patientListView;
                                    }

                                    ListGenerator.model.searches.add(searchData);
                                }
                            }, this);

                            ListGenerator.vent.trigger("add:search:" + type);
                        });


                        if (config.patients) {
                            ListGenerator.model.searches.add({
                                id: 'patients'
                            });
                        }

                        if (config.clinics || config.wards || config['wc-list']) {
                            ListGenerator.locationServiceResources.fetch().success( function () {
                                if (config.clinics) {
                                    self._addLocationSearch('clinics');
                                    ListGenerator.model.searches.get('clinics').set('dateFilter', "");
                                }
                                if (config.wards) {
                                    self._addLocationSearch('wards');
                                }
                                if (config['wc-list']) {
                                    console.log('wc listin');
                                    self._addWCLocationSearch();
                                    ListGenerator.model.searches.add({
                                        id: 'wc-list',
                                        patientCollection: new ListGenerator.Patients([], {
                                            url: Portal.WoundCareApplet.resources.get('skin-check-patient-search').get('href')
                                        })

                                    }, {merge:true});
                                }
                            });
                        }

                        ListGenerator.patientSearchResources.fetch().success( function (){
                            if (config.recent) {
                                ListGenerator.model.searches.add([
                                    {
                                        id: 'recent',
                                        patientCollection: new ListGenerator.Patients([], {
                                            url: ListGenerator.patientSearchResources.get('recent').get('href')
                                        })
                                    }
                                ]);
                                ListGenerator.model.searches.get('recent').get('patientCollection').fetch({
                                    url: ListGenerator.patientSearchResources.get('recent').get('href'),
                                    dataType: "json"
                                }).success(function() {
                                    ListGenerator.vent.trigger("load:recent");
                                });
                            }
                        });

                        /* // future feature
                            ListGenerator.model.searches.add([
                                {
                                    id: 'myList'
                                }
                            ]);
                        */
                    },
                    _addWCLocationSearch: function() {
                        ListGenerator.model.searches.add({
                            id: 'wc-list',
                            location: '',
                            locationFilter: '',
                            locationCollection: new ListGenerator.Wards( [], {
                                url: ListGenerator.locationServiceResources.get('wards').get('href')
                            } )
                        });
                        ListGenerator.model.searches.get('wc-list').get('locationCollection').fetch()
                            .success(function() {
                                ListGenerator.vent.trigger("load:wc-list");
                            }); 
                    },
                    _addLocationSearch: function (location) {
                        var LocationCollection = (location === 'clinics') ? ListGenerator.Clinics : ListGenerator.Wards;

                        ListGenerator.model.searches.add({
                            id: location,
                            location: '',
                            locationFilter: '',
                            locationCollection: new LocationCollection( [], {
                                url: ListGenerator.locationServiceResources.get(location).get('href')
                            } )
                        });

                        if (location === 'clinics') {
                            ListGenerator.model.searches.get('clinics').set('dateFilter', '');
                        }

                        ListGenerator.model.searches.get(location).get('locationCollection').fetch()
                            .success(function() {
                                ListGenerator.vent.trigger("load:" + location);
                            });
                    },
                    setPatientContext: function () {
                        var patient = ListGenerator.model.get('patient'),
                            fragment = _.any(Backbone.history.handlers, function(handler) {
                                            var fragment = "cover-sheet";
                                            return handler.route.test(fragment);
                                        }) ? "cover-sheet" : "";

                        patient.save({}, {
                            url: ListGenerator.patientSearchResources.get('recent').get('href')
                        });

                        Portal.execute( 'set-patient-context', {patient: patient} );
                        this.layout.trigger("close-modal-dialog", {fragment: fragment} );

                        if ( ListGenerator.model.get('configTypes').recent ) {
                            ListGenerator.model.searches.get('recent').get('patientCollection').fetch({
                                url: ListGenerator.patientSearchResources.get('recent').get('href'),
                                dataType: "json"
                            });
                        }
                    }
                });
            });
    });
